<?php
// views/agent_form.php
// Este arquivo deve ser incluído dentro de uma página que verifica sessão e inclui header/footer

// Se existir um ID de agente GET, carregue dados para edição
$agentId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$agentData = [
    'nome'       => '',
    'descricao'  => '',
    'config_json'=> '{}'
];

if ($agentId > 0) {
    $stmt = $pdo->prepare('SELECT * FROM agents WHERE id = ? AND user_id = ? LIMIT 1');
    $stmt->execute([$agentId, $_SESSION['user_id']]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row) {
        $agentData['nome']        = $row['nome'];
        $agentData['descricao']   = $row['descricao'];
        $agentData['config_json'] = $row['config_json'];
    } else {
        echo '<div class="alert error">Agente não encontrado.</div>';
        return;
    }
}
?>

<div class="agent-form-container">
  <h2><?= $agentId > 0 ? 'Editar Agente' : 'Criar Novo Agente' ?></h2>

  <form id="agent-form">
    <input type="hidden" id="agent-id" value="<?= $agentId ?>">

    <label for="agent-name">Nome do Agente:</label>
    <input type="text" id="agent-name" name="nome" value="<?= htmlspecialchars($agentData['nome']) ?>" required>

    <label for="agent-desc">Descrição (opcional):</label>
    <textarea id="agent-desc" name="descricao" rows="3"><?= htmlspecialchars($agentData['descricao']) ?></textarea>

    <label for="agent-config">Instruções / Configurações (JSON):</label>
    <textarea id="agent-config" name="config_json" rows="6"><?= htmlspecialchars($agentData['config_json']) ?></textarea>

    <button type="button" id="save-agent-btn" class="btn">Salvar Agente</button>
  </form>

  <div id="agent-feedback"></div>
</div>
