<?php
// chat_history.php
require_once __DIR__ . '/config.php';
if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Não autorizado']);
    exit;
}

$userId = $_SESSION['user_id'];
$convId = isset($_GET['conversation_id']) ? (int) $_GET['conversation_id'] : 0;
if ($convId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'ID de conversa inválido']);
    exit;
}

// Verifica se pertence ao usuário
$stmt = $pdo->prepare('SELECT id FROM conversations WHERE id = ? AND user_id = ? LIMIT 1');
$stmt->execute([$convId, $userId]);
if (!$stmt->fetch()) {
    http_response_code(403);
    echo json_encode(['error' => 'Conversa não encontrada']);
    exit;
}

$stmt = $pdo->prepare('
    SELECT role, content, created_at
    FROM messages
    WHERE conversation_id = ?
    ORDER BY created_at ASC
');
$stmt->execute([$convId]);
$mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

header('Content-Type: application/json; charset=utf-8');
echo json_encode($mensagens);
