<?php
// /chat/account_settings.php
require_once __DIR__ . '/config.php';

if (empty($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Carrega dados do usuário atual (email e api_key)
$stmt = $pdo->prepare('SELECT email, api_key FROM users WHERE id = ? LIMIT 1');
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Preparar mensagem de feedback (query string)
$feedbackType = $_GET['success'] ?? '';
$errorType    = $_GET['error']   ?? '';

$feedbackMsg = '';
if ($feedbackType !== '') {
    switch ($feedbackType) {
        case 'email':
            $feedbackMsg = '✅ Email atualizado com sucesso.';
            break;
        case 'password':
            $feedbackMsg = '✅ Senha alterada com sucesso.';
            break;
        case 'apikey':
            $feedbackMsg = '✅ API Key atualizada com sucesso.';
            break;
    }
} elseif ($errorType !== '') {
    switch ($errorType) {
        case 'email_invalid':
            $feedbackMsg = '❌ E-mail inválido.';
            break;
        case 'email_taken':
            $feedbackMsg = '❌ Este e-mail já está em uso.';
            break;
        case 'password_missing':
            $feedbackMsg = '❌ Preencha todos os campos de senha.';
            break;
        case 'wrong_current':
            $feedbackMsg = '❌ A senha atual está incorreta.';
            break;
        case 'confirm_mismatch':
            $feedbackMsg = '❌ A confirmação da nova senha não confere.';
            break;
        case 'password_short':
            $feedbackMsg = '❌ A nova senha deve ter ao menos 6 caracteres.';
            break;
        case 'apikey_invalid':
            $feedbackMsg = '❌ Formato de API Key inválido.';
            break;
        default:
            $feedbackMsg = '❌ Ocorreu um erro. Tente novamente.';
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Configurações da Conta – Cognis Chat</title>
  <link rel="stylesheet" href="public/assets/css/styles.css" />
</head>
<body data-theme="<?= isset($_COOKIE['theme']) ? htmlspecialchars($_COOKIE['theme']) : 'light' ?>">
  <?php include __DIR__ . '/views/header.php'; ?>

  <main class="account-settings-wrapper" style="max-width: 600px; margin: 2rem auto; color: var(--text-primary);">
    <div class="account-settings-container">
      <h2>Configurações da Conta</h2>

      <!-- BOTÃO VOLTAR AO CHAT -->
      <div style="margin: 1rem 0;">
        <a href="index.php" class="btn btn-secondary">← Voltar ao Chat</a>
      </div>

      <!-- MENSAGEM DE FEEDBACK/ERRO -->
      <?php if ($feedbackMsg !== ''): ?>
        <div class="feedback-message" style="margin-bottom: 1rem; color: var(--accent);">
          <?= htmlspecialchars($feedbackMsg) ?>
        </div>
      <?php endif; ?>

      <!-- =============================== -->
      <!-- FORMULÁRIO 1: Atualizar Email -->
      <!-- =============================== -->
      <form id="email-form"
            action="/chat/controllers/AccountController.php"
            method="POST"
            style="margin-bottom: 2rem;"
      >
        <input type="hidden" name="update_type" value="email" />

        <!-- 1) Email -->
        <div class="form-group">
          <label for="email" style="display: block; margin-bottom: 0.5rem;">Email:</label>
          <input
            type="email"
            id="email"
            name="email"
            value="<?= htmlspecialchars($user['email']) ?>"
            required
            style="width: 100%; padding: 0.5rem; border: 1px solid var(--border); border-radius: 4px; background-color: var(--input-background); color: var(--text-primary);"
          />
        </div>

        <button type="submit" class="btn btn-primary" style="margin-top: 0.75rem;">
          Atualizar Email
        </button>
      </form>

      <hr style="margin: 2rem 0; border-color: var(--border)">

      <!-- =============================== -->
      <!-- FORMULÁRIO 2: Alterar Senha -->
      <!-- =============================== -->
      <form id="password-form"
            action="/chat/controllers/AccountController.php"
            method="POST"
            style="margin-bottom: 2rem;"
      >
        <input type="hidden" name="update_type" value="password" />

        <h3>Alterar Senha</h3>

        <!-- 2) Senha Atual -->
        <div class="form-group">
          <label for="current-password" style="display: block; margin-bottom: 0.5rem;">Senha Atual:</label>
          <input
            type="password"
            id="current-password"
            name="current_password"
            placeholder="Digite sua senha atual"
            required
            style="width: 100%; padding: 0.5rem; border: 1px solid var(--border); border-radius: 4px; background-color: var(--input-background); color: var(--text-primary);"
          />
        </div>

        <!-- 3) Nova Senha -->
        <div class="form-group" style="margin-top: 1rem;">
          <label for="new-password" style="display: block; margin-bottom: 0.5rem;">Nova Senha:</label>
          <input
            type="password"
            id="new-password"
            name="new_password"
            placeholder="Digite a nova senha"
            required
            style="width: 100%; padding: 0.5rem; border: 1px solid var(--border); border-radius: 4px; background-color: var(--input-background); color: var(--text-primary);"
          />
        </div>

        <!-- 4) Confirmar Nova Senha -->
        <div class="form-group" style="margin-top: 1rem;">
          <label for="confirm-password" style="display: block; margin-bottom: 0.5rem;">Confirmar Nova Senha:</label>
          <input
            type="password"
            id="confirm-password"
            name="confirm_password"
            placeholder="Repita a nova senha"
            required
            style="width: 100%; padding: 0.5rem; border: 1px solid var(--border); border-radius: 4px; background-color: var(--input-background); color: var(--text-primary);"
          />
        </div>

        <button type="submit" class="btn btn-primary" style="margin-top: 0.75rem;">
          Atualizar Senha
        </button>
      </form>

      <hr style="margin: 2rem 0; border-color: var(--border)">

      <!-- =============================== -->
      <!-- FORMULÁRIO 3: Atualizar API Key -->
      <!-- =============================== -->
      <form id="api-key-form"
            action="/chat/controllers/AccountController.php"
            method="POST"
      >
        <input type="hidden" name="update_type" value="api_key" />

        <h3>Chave da API</h3>
        <div class="form-group" style="margin-top: 1rem;">
          <label for="api-key" style="display: block; margin-bottom: 0.5rem;">Sua Chave OpenAI:</label>
          <input
            type="text"
            id="api-key"
            name="api_key"
            value="<?= htmlspecialchars($user['api_key'] ?? '') ?>"
            placeholder="Cole aqui sua API Key"
            style="width: 100%; padding: 0.5rem; border: 1px solid var(--border); border-radius: 4px; background-color: var(--input-background); color: var(--text-primary);"
          />
          <small class="field-help" style="color: var(--text-tertiary);">
            Esta chave será usada para todas as chamadas à API OpenAI.
          </small>
        </div>

        <div style="display: flex; gap: 0.5rem; margin-top: 0.75rem;">
          <!-- Botão padrão que atualiza/insere nova chave -->
          <button type="submit" class="btn btn-primary">
            Atualizar API Key
          </button>

          <!-- Botão “Limpar Chave” (zera o campo e faz submit automaticamente) -->
          <button
            type="button"
            class="btn btn-secondary"
            onclick="
              document.getElementById('api-key').value = '';
              document.getElementById('api-key-form').submit();
            "
          >
            Limpar Chave
          </button><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
        </div>
      </form>
    </div>
  </main>

  <?php include __DIR__ . '/views/footer.php'; ?>
</body>
</html>
