<?php
// /chat/controllers/AccountController.php
require_once __DIR__ . '/../config.php';

if (empty($_SESSION['user_id'])) {
    header('Location: ../login.php');
    exit;
}

$userId     = $_SESSION['user_id'];
$updateType = $_POST['update_type'] ?? '';

switch ($updateType) {

    //----------------------------------------------------
    // 1) Atualizar Email
    //----------------------------------------------------
    case 'email':
        $newEmail = trim($_POST['email'] ?? '');
        if (!filter_var($newEmail, FILTER_VALIDATE_EMAIL)) {
            header('Location: ../account_settings.php?error=email_invalid');
            exit;
        }

        // Verifica se já existe outro usuário com este e-mail
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ? AND id <> ?');
        $stmt->execute([$newEmail, $userId]);
        if ($stmt->fetch()) {
            header('Location: ../account_settings.php?error=email_taken');
            exit;
        }

        $stmt = $pdo->prepare('UPDATE users SET email = ? WHERE id = ?');
        $stmt->execute([$newEmail, $userId]);

        header('Location: ../account_settings.php?success=email');
        exit;


    //----------------------------------------------------
    // 2) Atualizar Senha
    //----------------------------------------------------
    case 'password':
        $current = $_POST['current_password'] ?? '';
        $new     = $_POST['new_password']     ?? '';
        $confirm = $_POST['confirm_password'] ?? '';

        if (empty($current) || empty($new) || empty($confirm)) {
            header('Location: ../account_settings.php?error=password_missing');
            exit;
        }

        // Busca o hash atual
        $stmt = $pdo->prepare('SELECT senha_hash FROM users WHERE id = ?');
        $stmt->execute([$userId]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$row || !password_verify($current, $row['senha_hash'])) {
            header('Location: ../account_settings.php?error=wrong_current');
            exit;
        }

        if ($new !== $confirm) {
            header('Location: ../account_settings.php?error=confirm_mismatch');
            exit;
        }

        if (strlen($new) < 6) {
            header('Location: ../account_settings.php?error=password_short');
            exit;
        }

        $newHash = password_hash($new, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare('UPDATE users SET senha_hash = ? WHERE id = ?');
        $stmt->execute([$newHash, $userId]);

        header('Location: ../account_settings.php?success=password');
        exit;


    //----------------------------------------------------
    // 3) Atualizar API Key
    //----------------------------------------------------
    case 'api_key':
        $newKey = trim($_POST['api_key'] ?? '');

        // (Opcional: validar formato da chave "sk-xxxxx")
        // if ($newKey !== '' && !preg_match('/^sk-[A-Za-z0-9]{32,}$/', $newKey)) {
        //     header('Location: ../account_settings.php?error=apikey_invalid');
        //     exit;
        // }

        $stmt = $pdo->prepare('UPDATE users SET api_key = ? WHERE id = ?');
        $stmt->execute([$newKey, $userId]);

        header('Location: ../account_settings.php?success=apikey');
        exit;


    //----------------------------------------------------
    // Caso nenhum update_type válido
    //----------------------------------------------------
    default:
        header('Location: ../account_settings.php');
        exit;
}
