<?php
// /chat/views/header.php
?>
<header class="header" style="display: flex; justify-content: space-between; align-items: center; padding: 1rem; background-color: var(--header-bg); border-bottom: 1px solid var(--border);">
  <div class="header-left">
    <h1 class="logo" style="margin: 0; color: var(--header-text);">Cognis Chat</h1>
  </div>
  <div class="header-right" style="display: flex; align-items: center; gap: 1rem;">
    <!-- Agora o nome do usuário é um link que leva a account_settings.php -->
    <a href="account_settings.php" class="user-greeting" style="color: var(--header-text); text-decoration: none; font-size: 0.9rem;">
      Olá, <?= htmlspecialchars($_SESSION['user_name']) ?>
    </a>
    <button id="theme-toggle" class="btn btn-secondary">
      Modo Escuro
    </button>
    <button id="sair" href="logout.php" class="btn btn-danger" style="white-space: nowrap;">Sair</a>
  </div>
</header>

<script>
  // Alterna texto e tema do botão “Modo Escuro” / “Modo Claro”
  document.addEventListener('DOMContentLoaded', () => {
    const themeToggleBtn = document.getElementById('theme-toggle');
    const rootEl = document.documentElement;

    function applyTheme(theme) {
      rootEl.setAttribute('data-theme', theme);
      localStorage.setItem('theme', theme);
      // Ajusta texto do botão conforme o tema atual
      themeToggleBtn.textContent = theme === 'dark' ? 'Modo Claro' : 'Modo Escuro';
    }

    // Aplica tema salvo no localStorage, ou detecta via prefers-color-scheme
    const savedTheme = localStorage.getItem('theme');
    if (savedTheme) {
      applyTheme(savedTheme);
    } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
      applyTheme('dark');
    } else {
      applyTheme('light');
    }

    themeToggleBtn.addEventListener('click', () => {
      const current = rootEl.getAttribute('data-theme') === 'dark' ? 'dark' : 'light';
      const next = current === 'dark' ? 'light' : 'dark';
      applyTheme(next);
    });
  });
</script>
